<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Api;

interface ConfigInterface
{
    /**
     * Check if payment method is enabled
     *
     * @return bool
     */
    public function isEnabled(): bool;

    /**
     * Check if test mode is active
     *
     * @return bool
     */
    public function isTestMode(): bool;

    /**
     * Get selected network
     *
     * @return string
     */
    public function getNetwork(): string;

    /**
     * Get merchant wallet address
     *
     * @return string
     */
    public function getMerchantAddress(): string;

    /**
     * Get smart contract address
     *
     * @return string
     */
    public function getContractAddress(): string;

    /**
     * Get accepted currencies
     *
     * @return array
     */
    public function getAcceptedCurrencies(): array;

    /**
     * Get network configuration
     *
     * @return array
     */
    public function getNetworkConfig(): array;

    /**
     * Get RPC URL for current network
     *
     * @return string
     */
    public function getRpcUrl(): string;

    /**
     * Get chain ID for current network
     *
     * @return int
     */
    public function getChainId(): int;
}
