{**
 * LayerPay Admin Order Info Template
 *}

<div class="panel">
    <div class="panel-heading">
        <i class="icon-bitcoin"></i> {l s='LayerPay Crypto Payment' mod='layerpay'}
    </div>
    <div class="panel-body">
        {if $payment_data}
        <table class="table">
            <tr>
                <td><strong>{l s='Transaction Hash' mod='layerpay'}</strong></td>
                <td>
                    <code>{$payment_data.tx_hash|escape:'htmlall':'UTF-8'}</code>
                    {if isset($networks[$payment_data.network])}
                    <a href="{$networks[$payment_data.network].explorer}/tx/{$payment_data.tx_hash|escape:'htmlall':'UTF-8'}"
                       target="_blank" class="btn btn-xs btn-default">
                        <i class="icon-external-link"></i> {l s='View on Explorer' mod='layerpay'}
                    </a>
                    {/if}
                </td>
            </tr>
            <tr>
                <td><strong>{l s='Network' mod='layerpay'}</strong></td>
                <td>
                    {if isset($networks[$payment_data.network])}
                        {$networks[$payment_data.network].name|escape:'htmlall':'UTF-8'}
                    {else}
                        {$payment_data.network|escape:'htmlall':'UTF-8'}
                    {/if}
                </td>
            </tr>
            <tr>
                <td><strong>{l s='Amount' mod='layerpay'}</strong></td>
                <td>{$payment_data.crypto_amount|escape:'htmlall':'UTF-8'} {$payment_data.payment_type|upper|escape:'htmlall':'UTF-8'}</td>
            </tr>
            <tr>
                <td><strong>{l s='Payment Type' mod='layerpay'}</strong></td>
                <td>{$payment_data.payment_type|upper|escape:'htmlall':'UTF-8'}</td>
            </tr>
            <tr>
                <td><strong>{l s='Payer Address' mod='layerpay'}</strong></td>
                <td><code>{$payment_data.payer_address|escape:'htmlall':'UTF-8'}</code></td>
            </tr>
            <tr>
                <td><strong>{l s='Verified' mod='layerpay'}</strong></td>
                <td>
                    {if $payment_data.verified}
                    <span class="label label-success">{l s='Yes' mod='layerpay'}</span>
                    {else}
                    <span class="label label-warning">{l s='Pending' mod='layerpay'}</span>
                    {/if}
                </td>
            </tr>
            <tr>
                <td><strong>{l s='Date' mod='layerpay'}</strong></td>
                <td>{$payment_data.created_at|escape:'htmlall':'UTF-8'}</td>
            </tr>
        </table>
        {else}
        <div class="alert alert-info">
            {l s='No crypto payment data found for this order.' mod='layerpay'}
        </div>
        {/if}
    </div>
</div>
